<?php get_header(); ?>

<!-- Hero Section -->
<section id="home" class="hero">
    <div class="container hero-content">
        <!-- Logo ditambahkan di sini -->
        <div class="hero-logo">
            <img src="https://parawangsa.co.id/wp-content/uploads/2025/09/WhatsApp-Image-2025-07-30-at-22.51.41-removebg-preview.png" alt="Parawangsa Persada Nusantara">
        </div>
        <h1>Mewujudkan Perjalanan, Membangun Cerita</h1>
        <p>Tempat di mana perjalanan bukan hanya perpindahan, tetapi pengalaman yang mengubah cara Anda melihat dunia.</p>
        <a href="#services" class="btn">Jelajahi Layanan Kami</a>
    </div>
</section>

<!-- About Section -->
<section id="about" class="section about">
    <div class="container">
        <h2 class="section-title">Tentang Parawangsa Persada Nusantara</h2>
        <div class="about-content">
            <div class="about-text">
                <p>Di tengah pesatnya dunia pariwisata, PT. Parawangsa Persada Nusantara hadir sebagai solusi perjalanan modern yang mengedepankan kualitas, ketepatan, dan pengalaman emosional.</p>
                <p>Didirikan pada 16 Mei 2025, kami berkomitmen untuk menghadirkan layanan perjalanan yang bukan hanya sekadar wisata, tapi juga menghadirkan kisah yang berkesan di setiap langkahnya.</p>
                <p>Kami adalah lebih dari sekadar biro perjalanan. Kami adalah kurator pengalaman, penjaga kenyamanan, dan arsitek momen.</p>
                <blockquote>
                    "Perjalanan terbaik bukanlah soal tempat, melainkan bagaimana Anda merasakannya."
                </blockquote>
            </div>
            <div class="about-image">
                <img src="https://images.unsplash.com/photo-1531538606174-0f90ff5dce83?ixlib=rb-1.2.1&auto=format&fit=crop&w=700&q=80" alt="About Parawangsa">
            </div>
        </div>
        
        <div class="vision-mission">
            <div class="vm-card">
                <h3>Visi Kami</h3>
                <p>Menjadi simbol keunggulan dalam industri pariwisata nasional dan internasional melalui pelayanan yang autentik, inovatif, dan tak terlupakan.</p>
            </div>
            <div class="vm-card">
                <h3>Misi Kami</h3>
                <ul>
                    <li>Menciptakan perjalanan yang menginspirasi dan personal.</li>
                    <li>Mengintegrasikan teknologi dan pelayanan untuk kemudahan pelanggan.</li>
                    <li>Menjadi mitra terpercaya bagi individu, komunitas, dan korporasi.</li>
                    <li>Menumbuhkan kecintaan terhadap keindahan Indonesia dan dunia.</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section id="services" class="section">
    <div class="container">
        <h2 class="section-title">Layanan Eksklusif Kami</h2>
        <div class="services-grid">
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-globe-asia"></i>
                </div>
                <h3>Eksplorasi Domestik & Internasional</h3>
                <p>Custom trip ke destinasi unggulan di dalam & luar negeri – mulai dari Bali, Raja Ampat, hingga Eropa & Asia Timur.</p>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-users"></i>
                </div>
                <h3>Open Trip & Signature Private Tour</h3>
                <p>Liburan hemat dalam kelompok kecil, atau eksklusif privat bersama orang tercinta.</p>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-hotel"></i>
                </div>
                <h3>Tiket & Akomodasi Premium</h3>
                <p>Kemudahan pemesanan tiket pesawat, hotel, dan resort kelas dunia.</p>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-mosque"></i>
                </div>
                <h3>Umroh & Haji Plus Berkelas</h3>
                <p>Bimbingan spiritual, layanan premium, dan kenyamanan ibadah.</p>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-passport"></i>
                </div>
                <h3>Visa Assistance & Travel Insurance</h3>
                <p>Proses mudah dan aman untuk destinasi internasional.</p>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <i class="fas fa-briefcase"></i>
                </div>
                <h3>MICE & Corporate Travel</h3>
                <p>Meeting, Incentive, Conference, Exhibition – dikelola profesional dan efisien.</p>
            </div>
        </div>
    </div>
</section>

<!-- Differentiators Section -->
<section id="differentiators" class="section differentiators">
    <div class="container">
        <h2 class="section-title">Apa yang Membuat Kami Berbeda?</h2>
        <div class="diff-grid">
            <div class="diff-item">
                <div class="diff-icon">
                    <i class="fas fa-user-cog"></i>
                </div>
                <h3>Personalisasi Perjalanan</h3>
                <p>Kami mendengarkan. Kami merancang setiap detail berdasarkan kebutuhan Anda.</p>
            </div>
            <div class="diff-item">
                <div class="diff-icon">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <h3>Teknologi & Akses Digital</h3>
                <p>Dari pemesanan online hingga live itinerary — semua dalam genggaman Anda.</p>
            </div>
            <div class="diff-item">
                <div class="diff-icon">
                    <i class="fas fa-star"></i>
                </div>
                <h3>Pengalaman Tanpa Kompromi</h3>
                <p>Kualitas layanan kami dijaga dari awal hingga Anda pulang dengan senyuman.</p>
            </div>
            <div class="diff-item">
                <div class="diff-icon">
                    <i class="fas fa-users"></i>
                </div>
                <h3>Tim Profesional & Passionate</h3>
                <p>Dipandu oleh ahli perjalanan berpengalaman dan berkomitmen pada pelayanan kelas atas.</p>
            </div>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section id="contact" class="section">
    <div class="container">
        <h2 class="section-title">Hubungi Kami</h2>
        <div class="contact-container">
            <div class="contact-info">
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div>
                        <h3>Alamat Kantor</h3>
                        <p>Ruko Pondok Cabe Mutiara Blok A No. 1<br>Pondok Cabe Udik, Pamulang<br>Tangerang Selatan, Banten</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div>
                        <h3>Telepon</h3>
                        <p>(021) 7445539</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <h3>Email</h3>
                        <p>parawangsapersadanusantara@gmail.com</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <div>
                        <h3>Website</h3>
                        <p>www.parawangsa.co.id</p>
                    </div>
                </div>
            </div>
            <div class="contact-form">
                <h3>Kirim Pesan</h3>
                <?php echo do_shortcode('[wpforms id="38"]'); ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>