(function($) {
	'use strict';
	
    // Wait until the document is fully loaded
	$(document).ready(function() {
		console.log('Floating Promo Admin JS loaded');
		
        // Handle image upload
		$('#upload_banner_image').on('click', function(e) {
			e.preventDefault();
			console.log('Upload button clicked');
			
            // Create media frame with custom settings
			var frame = wp.media({
				title: 'Pilih Gambar Banner - Rekomendasi ukuran: 700x800px',
				multiple: false,
				library: {
					type: 'image'
				},
				button: {
					text: 'Gunakan Gambar Ini'
				}
			});
			
            // Handle selection
			frame.on('select', function() {
				var attachment = frame.state().get('selection').first().toJSON();
				console.log('Image selected:', attachment);
				
				$('#banner_image_url').val(attachment.url);
				
                // Create preview with recommended size info
				var previewHtml = '<img src="' + attachment.url + '" style="max-width: 300px; height: auto;">';
				previewHtml += '<div class="recommended-size">Rekomendasi ukuran: 700x800px</div>';
				
				$('#banner_image_preview').html(previewHtml);
				$('#remove_banner_image').show();
				
                // Show notice if image dimensions are not optimal
				if (attachment.width && attachment.height) {
					var ratio = attachment.width / attachment.height;
                    var targetRatio = 700 / 800; // 0.875
                    
                    if (Math.abs(ratio - targetRatio) > 0.2) {
                    	$('#banner_image_preview').append(
                    		'<div class="notice notice-warning inline" style="margin-top: 10px;">' +
                    		'<p>Rasio gambar tidak optimal. Disarankan: 700x800px (rasio 0.875). Rasio saat ini: ' + 
                    		ratio.toFixed(2) + '</p></div>'
                    		);
                    }
                }
            });
			
            // Open media frame
			frame.open();
		});
		
        // Handle image removal
		$('#remove_banner_image').on('click', function(e) {
			e.preventDefault();
			console.log('Remove button clicked');
			
			$('#banner_image_url').val('');
			$('#banner_image_preview').html('');
			$(this).hide();
		});
		
        // Debug: Check if elements exist
		console.log('Upload button exists:', $('#upload_banner_image').length > 0);
		console.log('Remove button exists:', $('#remove_banner_image').length > 0);
		console.log('Image URL field exists:', $('#banner_image_url').length > 0);
		console.log('Image preview exists:', $('#banner_image_preview').length > 0);
	});
	
})(jQuery);